/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.block;

import de.cristelknight.doapi.common.block.StorageBlock;
import de.cristelknight.doapi.common.util.GeneralUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.farm_and_charm.registry.StorageTypeRegistry;
import net.satisfy.farm_and_charm.registry.TagRegistry;
import org.jetbrains.annotations.NotNull;

public class ToolRackBlock
extends StorageBlock {
    private static final Supplier<VoxelShape> voxelShapeSupplier = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.8125, (double)0.875, (double)1.0, (double)0.9375, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    public static final Map<Direction, VoxelShape> SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)voxelShapeSupplier.get()));
        }
    });

    public ToolRackBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE.get(state.m_61143_((Property)f_54117_));
    }

    public boolean canInsertStack(ItemStack stack) {
        return stack.m_41720_() instanceof TieredItem || stack.m_41720_() == Items.f_42574_ || stack.m_41720_() == Items.f_42523_ || stack.m_41720_() == Items.f_151059_ || stack.m_204117_(TagRegistry.HANGABLE);
    }

    public ResourceLocation type() {
        return StorageTypeRegistry.TOOL_RACK;
    }

    public Direction[] unAllowedDirections() {
        return new Direction[]{Direction.DOWN};
    }

    public int getSection(Float f, Float y) {
        float oneS = 0.33333334f;
        int nSection = (int)(f.floatValue() / oneS);
        return 2 - nSection;
    }

    public int size() {
        return 3;
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_((Property)f_54117_);
        if (facing == Direction.DOWN) {
            BlockPos blockAbove = pos.m_7494_();
            return world.m_8055_(blockAbove).m_60783_((BlockGetter)world, blockAbove, Direction.DOWN);
        }
        if (facing == Direction.UP) {
            return false;
        }
        BlockPos neighborPos = pos.m_121945_(facing.m_122424_());
        BlockState neighborState = world.m_8055_(neighborPos);
        return neighborState.m_60783_((BlockGetter)world, neighborPos, facing);
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_46961_(pos, true);
        }
    }

    @NotNull
    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_186460_(pos, (Block)this, 1);
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public void m_5871_(ItemStack itemStack, BlockGetter world, List<Component> tooltip, TooltipFlag tooltipContext) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.farm_and_charm.canbeplacedwall").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
    }
}

